# cumfirstNot {#cumfirstnot}

## Syntax {#syntax}

`cumfirstNot(X, [k])`

## Arguments {#arguments}

**k** is a scalar.

Please see [Cumulative Window Functions](../Themes/cumFunctions.md) for the parameter description and windowing logic.

## Details {#details}

If *X* is a vector:

-   If *k* is unspecified, return the first non-null element in *X*;
-   If *k* is specified, return the first element that is not *k*.

If *X* is a matrix, conduct the aforementioned calculation within each column of *X*. The result is a matrix with the same shape as *X*.

## Examples {#examples}

```
x=[NULL,1,2,6,NULL,3,4,NULL]
cumfirstNot(x);
// output: [,1,1,1,1,1,1,1]

cumfirstNot(x, 1)
// output: [,,2,2,2,2,2,2]

m=matrix(1 2 3 NULL 4, NULL NULL 8 8 9);
m;
```

|\#0|\#1|
|---|---|
|1||
|2||
|3|8|
||8|
|4|9|

```
cumfirstNot(m);
```

|\#0|\#1|
|---|---|
|1||
|1||
|1|8|
|1|8|
|1|8|

Related function: [firstNot](../f/firstNot.md)

