# cumPositiveStreak {#cumpositivestreak}

## Syntax {#syntax}

`cumPositiveStreak(X)`

Please see [Cumulative Window Functions](../Themes/cumFunctions.md) for the parameter description and windowing logic.

## Details {#details}

Cumulatively calculate the sum of consecutive positive elements of *X* after the last non-positive element to the left.

## Examples {#examples}

```
x=1 0 -1 1 2 2 2 1 0 -1 0 2;

cumPositiveStreak x;
// output: [1,0,0,1,3,5,7,8,0,0,0,2]

m=matrix(1 0 -1 1 2 2 2 1 0 -1 0 2, -1 -2 -1 0 1 3 6 7 0 -1 -2 0);
m;
```

|\#0|\#1|
|---|---|
|1|-1|
|0|-2|
|-1|-1|
|1|0|
|2|1|
|2|3|
|2|6|
|1|7|
|0|0|
|-1|-1|
|0|-2|
|2|0|

```
cumPositiveStreak(m);
```

|\#0|\#1|
|---|---|
|1|0|
|0|0|
|0|0|
|1|0|
|3|1|
|5|4|
|7|10|
|8|17|
|0|0|
|0|0|
|0|0|
|2|0|

relaated functions: [cumsum](cumsum.md), [cummax](cummax.md), [cummin](cummin.md), [cumprod](cumprod.md)

