# cubicSpline {#cubicspline}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cubicSpline(x, y, bc_type="not-a-knot")`

## Arguments {#arguments}

**x** is a numeric vector containing values of the independent variable. The length of *x*must be no smaller than 3. Its values must be real and in strictly increasing order.

**y** is a numeric vector containing values of the dependent variable. The length of *y* must match the length of *x*.

**bc\_type** is of STRING type, which can be a scalar, pair, or a vector of length no greater than 2. It specifies the boundary condition type.

-   If *bc\_type*is a string or a vector of length 1, the specified condition will be applied at both ends of a spline.

-   If *bc\_type*is a pair or a vector of length 2, the first and the second value will be applied at the curve start and end respectively.


Its value can be:

-   "not-a-knot" \(default\): The first and second segment at a curve end are the same polynomial.

-   "clamped": The first derivative at curves ends are zero.

-   "natural": The second derivative at curve ends are zero.


## Details {#details}

Cubic spline data interpolator.

**Return value**: A dictionary withthe following keys:

-   c: Coefficients of the polynomials on each segment.
-   x: Breakpoints. The input *x*.
-   predict: A prediction function of the model, which returns the cubic spline interpolation result at point X. It can be called using `model.predict(X)` or `predict(model, X)`, where
    -   model: A dictionary indicating the output of `cubicSpline`.
    -   X: A numeric vector indicating the X-coordinate of the point to be queried.
-   modelName: A string indicating the model name, which is “`cubicSpline`”.

## Examples {#examples}

``` {#codeblock_o12_mx3_21c}
n = 10
x = 0..(n-1)
y = sin(x)
model = cubicSpline(x, y, bc_type="not-a-knot")
model

/* output
x->[0,1,2,3,4,5,6,7,8,9]
predict->cubicSplinePredict
modelName->cubicSpline
c->[-0.0418500756165063,-0.2612720445455365,1.1445931049699394,0.0,-0.0418500756165067,-0.3868222713950554,0.4964987890293473,0.8414709848078965,0.1468910600890447,-0.5123724982445756,...]
*/
```

Related Function: [cubicSplinePredict](cubicsplinepredict.md)

