# createUser {#createuser}

## Syntax {#syntax}

`createUser(userId, password, [groupIds], [isAdmin=false], [authMode])`

## Arguments {#arguments}

**userId** is a string indicating a user name. It can only contain letters, underscores, or numbers. It cannot start with numbers or underscores. The length cannot exceed 30 characters.

**password** is a string indicating the password. It cannot contain space or control characters.

Since DolphinDB 2.00.10.10, users can determine whether to verify the complexity of *password* by setting the configuration *enhancedSecurityVerification*. If it is not specified, no verification will be applied; if it is set to true, the password must meet the following conditions:

-   8-20 characters

-   at least 1 capital letter

-   at least 1 special character, including !"\#$%&amp;'\(\)\*+,-./:;&lt;=&gt;?@\[\]^\_\`\{\|\}~


**groupIds** \(optional\) is a STRING scalar/vector indicating the group\(s\) the user belongs to.

**isAdmin** \(optional\) is a Boolean value indicating whether the user is an administrator.

**authMode**\(optional\) specifies the authentication method for user login. By default, it uses "sha256", allowing users to log in via the `login` function with SHA-256 authentication. Alternatively, you can set it to "scram", which enables login via the SCRAM \(Salted Challenge Response Authentication Mechanism\) protocol for enhanced security.

**Note:**

SCRAM is implemented based on the [IETF's RFC 5802 standard](https://datatracker.ietf.org/doc/html/rfc5802). Through high-strength hash algorithms, mutual authentication, and other measures, it provides higher security for password-based login.

DolphinDB's API already supports SCRAM authentication:

-   When connecting to a DolphinDB server using the API's native methods, the API will prioritize SCRAM authentication.
-   If the user has not enabled SCRAM authentication, it will automatically fall back to the default login method.
-   If not using the API's encapsulated interfaces and opting for manual SCRAM login, you need to call the scramClientFirstand scramClientFinal functions from the server side. For specific procedures, refer to the function documentation.

After enabling SCRAM authentication, password-related functions such as `login`, `resetPwd`, and `changePwd` remain valid.

## Details {#details}

Create a user. It can only be executed by an administrator.

The groups in *groupIds* must have been created with [createGroup](createGroup.md).

## Examples {#examples}

Create a non-admin user with username 'JohnSmith' and password 'Qb0507'. This user will use the default SHA-256 authentication method for login. This user belongs to group "research" and group "production. He is not an administrator.

```
createUser(`JohnSmith, "Qb0507#$", `research`production);
```

