# createOrcaKeyedStreamTable {#createOrcaKeyedStreamTable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`createOrcaKeyedStreamTable(name, keyColumn, colNames, colTypes, [asyncWrite=true], [compress=true], [cacheSize], [retentionMinutes=1440], [flushMode=0], [preCache], [cachePurgeTimeColumn], [cachePurgeInterval], [cacheRetentionTime])`

## Details {#topic_zq2_r5d_ngc}

Creates a persisted keyed stream table. For details, see [keyedStreamTable](https://docs.dolphindb.com/en/Functions/k/keyedStreamTable.html) and [enableTableShareAndPersistence](https://docs.dolphindb.com/en/Functions/e/enableTableShareAndPersistence.html).

The difference from `StreamGraph::keyedSource` is that `createOrcaKeyedStreamTable` does not rely on a stream graph.

## Arguments {#arguments}

**name** is a string representing the name of the Orca stream table. You can provide either the fully qualified name \(FQN\), such as "trading.orca\_table.factors", or just the table name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

**keyColumn** is a string scalar or vector indicating the name of the primary key columns \(which must be of INTEGRAL, TEMPORAL, LITERAL or FLOATING type\).

**colNames** is a STRING vector of column names.

**colTypes** is a STRING vector of data types. It can use either the reserved words for data types or corresponding strings.

**asyncWrite** \(optional\) is a Boolean value indicating whether persistence is enabled in asynchronous mode. The default value is true, meaning asynchronous persistence is enabled. In this case, once data is written into memory, the write is deemed complete. The data stored in memory is then persisted to disk by another thread.

**compress** \(optional\) is a Boolean value indicating whether to save a table to disk in compression mode. The default value is true.

**cacheSize** \(optional\) is an integer used to determine the maximum number of records to retain in memory. If set to 0 or not specified, all records will be retained. Any positive integer smaller than 1000 will automatically be adjusted to 1000.

**retentionMinutes** \(optional\) is an integer indicating for how long \(in minutes\) a log file larger than 1GB will be kept after last update. The default value is 1440, which means the log file is kept for 1440 minutes, i.e., 1 day.

**flushMode** \(optional\) is an integer indicating whether to enable synchronous disk flush. It can be 0 or 1. The persistence process first writes data from memory to the page cache, then flushes the cached data to disk. If *flushMode* is 0 \(default\), asynchronous disk flushing is enabled. In this case, once data is written from memory to the page cache, the flush is deemed complete and the next batch of data can be written to the table. If *flushMode* is set to 1, the current batch of data must be flushed to disk before the next batch can be written.

**preCache** \(optional\) is an integer indicating the number of records to be loaded into memory from the persisted stream table on disk when DolphinDB restarts. If it is not specified, all records are loaded into memory when DolphinDB restarts.

**cachePurgeTimeColumn** \(optional\) is a STRING scalar indicating the time column in the stream table.

**cachePurgeInterval** \(optional\) is a DURATION scalar indicating the interval to trigger cache purge.

**cacheRetentionTime** \(optional\) is a DURATION scalar indicating the retention time of cached data. Note: Since version 3.00.2/2.00.14, *cacheRetentionTime* must be smaller than *cachePurgeInterval*.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
if(!existsCatalog("demo")){
    createCatalog("demo")
}
go
use catalog demo

createOrcaKeyedStreamTable("trade", `symbol, `time`symbol`price`volume, [DATETIME,SYMBOL,DOUBLE,LONG])
```

