# createOrcaHaStreamTable {#createOrcaHaStreamTable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`createOrcaHaStreamTable(name, colNames, colTypes, raftGroup, cacheLimit, [retentionMinutes=1440])`

## Details {#topic_cgj_gvd_ngc}

Creates a high-availability stream table. For details, see [haStreamTable](https://docs.dolphindb.com/en/Functions/h/haStreamTable.html).

The difference from `StreamGraph::haSource` is that `createOrcaHaStreamTable` does not rely on a stream graph.

## Arguments {#arguments}

**name** is a string representing the name of the Orca stream table. You can provide either the fully qualified name \(FQN\), such as "trading.orca\_table.factors", or just the table name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

**colNames** is a STRING vector of column names.

**colTypes** is a STRING vector of data types. It can use either the reserved words for data types or corresponding strings.

**raftGroup** can be either an integer greater than 1 or a string.

-   Integer: represents the raft group ID.
-   String: represents a raft group alias, which must be preconfigured via *streamingRaftGroupAliases*.

**cacheLimit** is an integer representing the maximum number of rows of the high-availability stream table to be kept in memory. If *cacheLimit*&gt;1000, it is automatically adjusted to 1000.

**retentionMinutes** \(optional\) is an integer indicating for how long \(in terms of minutes\) a log file larger than 1GB will be kept after last update. The default value is 1440, which means the log file only keeps data in the past 24 hours.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
if(!existsCatalog("demo")){
    createCatalog("demo")
}
go
use catalog demo

createOrcaHaStreamTable("ha_table",`time`symbol`price`volume, [DATETIME,SYMBOL,DOUBLE,LONG], 3, 50000)
```

