# createIMOLTPTable {#createIMOLTPTable}

## Syntax {#Syntax .section}

`createIMOLTPTable(dbHandle, table, tableName, primaryKey, [secondaryKey], [uniqueFlag])`

## Details {#Details .section}

Create a table in an IMOLTP database.

## Arguments {#Arguments .section}

**dbHandle** is a database handle returned by the database function.

**table** is a table object whose schema is used to define the schema for the new table in an IMOLTP database.

**tableName** is a STRING scalar indicating the table name.

**primaryKey** is a STRING scalar or vector that specifies the primary key column\(s\).

**secondaryKey** \(optional\) is a STRING scalar or vector that specifies the secondary key column\(s\).

**uniqueFlag**\(optional\) is a Boolean scalar or vector, indicating whether each secondary key is unique. When *uniqueFlag* is a vector, the size of *secondaryKey* and *uniqueFlag* must be the same.

## Examples {#Examples .section}

First, create a table in an IMOLTP database.

``` {#codeblock_f2w_dff_jbc}
dbName = "oltp://test_imoltp"
db = database(directory=dbName, partitionType=VALUE, partitionScheme=1..100, engine="IMOLTP")
```

\(1\) Create a table "test\_table\_1" in an IMOLTP database and define a primary key on the column "id".

``` {#codeblock_dn4_2ff_jbc}
pt1 = createIMOLTPTable(
    dbHandle=db,
    table=table(1:0, ["id", "val1", "val2", "sym"], [LONG, INT, LONG, STRING]),
    tableName="test_table_1",
    primaryKey=`id
)
```

\(2\) Create a table "test\_table\_2" in an IMOLTP database. Define a primary key on columns "id" and "sym" and unique secondary keys on "val2" and "sym".

``` {#codeblock_kw2_fff_jbc}
pt2 = createIMOLTPTable(
    dbHandle=db,
    table=table(1:0, ["id", "val1", "val2", "sym"], [LONG, INT, LONG, STRING]),
    tableName="test_table_2",
    primaryKey=`id`sym,
    secondaryKey=`val2`sym,
    uniqueFlag=true
)
```

\(3\) Create a table "test\_table\_3" in an IMOLTP database. Define a primary key on the column "id", non-unique secondary key on "val1" and unique secondary key on "sym".

``` {#codeblock_mzv_fff_jbc}
pt3 = createIMOLTPTable(
    dbHandle=db,
    table=table(1:0, ["id", "val1", "val2", "sym"], [LONG, INT, LONG, STRING]),
    tableName="test_table_3",
    primaryKey=`id,
    secondaryKey=`val1`sym,
    uniqueFlag=[false, true]
)
```

