# convertExcelFormula {#convertexcelformula}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`convertExcelFormula(formula, colStart, colEnd, rowStart, rowEnd)`

## Arguments {#arguments}

**formula** is a STRING scalar/vector indicating an Excel formula.

**colStart** is a STRING scalar indicating the starting column of the data in Excel.

**colEnd** is a STRING scalar indicating the ending column of the data in Excel.

**rowStart** is a positive integer indicating the starting row of the data in Excel.

**rowEnd** is a positive integer indicating the ending row of the data in Excel. *rowEnd* must be greater than or equal to *rowStart*.

## Details {#details}

Convert Excel formula to DolphinDB expressions.

The function only supports the following conversions: the arithmetic operations, logical operations, and aggregate functions.

Currently, it does not support converting the expressions that operate on both rows and columns.

When applying an aggregate function on a single column, the aggregation will be performed on this column if the processing row number is equal to the actual row number. Otherwise, the aggregation will be performed on a moving window.

## Examples {#examples}

```
convertExcelFormula("A2+B2", "A", "Z", 2, 10);
// output: col0+col1

convertExcelFormula("SUM(A2:C2)", "A", "Z", 2, 10);
// output: rowSum(col0, col1, col2)

convertExcelFormula("SUM(A2)", "A", "Z", 2, 10);
// output: cumsum(col0)

convertExcelFormula("SUM(A2:A5)", "A", "Z", 2, 10);
// output: msum(col0, 4)

convertExcelFormula("SUM(A2:A10)", "A", "Z", 2, 10);
// output: sum(col0)

convertExcelFormula(["=SUM(A1:A10)","IF(A1>0,B1,0"], "A", "D", 1, 10)
// output: ["sum(col0)","iif(col0>0,col1,0)"]
```

