# convertEncode {#convertencode}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`convertEncode(str, srcEncode, destEncode)`

## Arguments {#arguments}

**str** can be a STRING scalar/vector, a dictionary with string values, or a table.

**srcEncode** is a string indicating the original encoding name.

**destEncode** is a string indicating the new encoding name.

## Details {#details}

Change the encoding of strings. All encoding names must use lowercase.

The Linux version supports conversion between any two encodings. The Windows version only supports conversion between GBK and UTF-8.

## Examples {#examples}

```
convertEncode("high-performance time-series database","utf-8","gbk");
// output: high-performance time-series database

convertEncode(["hello","DolphinDB"],"gbk","utf-8");
// output: ["hello","DolphinDB"]
```

`convertEncode` can convert a dictionary with string values.

``` {#codeblock_whh_cfx_rfc}
x=1 2 3
y= `C1`C2`D1
d=dict(x,y)
convertEncode(d, "UTF-8", "GBK")
// output: 
1: C1
2: C2
3: D1
*/
```

`convertEncode` automatically detects and converts all string columns in a table, while ignoring columns of other data types.

``` {#codeblock_ocx_bgx_rfc}
t=table(["t1", "t1", "t2", "t3"] as type, [11, 11.5, 10, 14] as price)
convertEncode(t, "UTF-8", "GBK")
```

|type|price|
|----|-----|
|t1|11|
|t1|11.5|
|t2|10|
|t3|14|

Related functions: [fromUTF8](../f/fromUTF8.md), [toUTF8](../t/toUTF8.md)

