# concatMatrix {#concatmatrix}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`concatMatrix(X, [horizontal=true])`

## Arguments {#arguments}

**X** is a tuple of multiple matrices.

**horizontal** \(optional\) is a Boolean value indicating whether the matrices are contatenated horizontally. The default value is true. If set to false, the matrices are contatenated vertically.

## Details {#details}

Concatenate the matrices vertically or horizontally.

When you concatenate matrices horizontally, they must have the same number of rows. When you concatenate them vertically, they must have the same number of columns.

## Examples {#examples}

```
m1 = matrix(4 0 5, 2 1 8);
m2 = matrix(2 9 8, 3 7 -3, 6 4 2, 0 5 8);
m3 = matrix(1 -1 6 2, 1 -3 1 9, 5 3 0 -4, 1 NULL 3 4);
concatMatrix([m1, m2]);
```

|col1|col2|col3|col4|col5|col6|
|----|----|----|----|----|----|
|4|2|2|3|6|0|
|0|1|9|7|4|5|
|5|8|8|-3|2|8|

```
print concatMatrix([m2, m3], false);
```

|col1|col2|col3|col4|
|----|----|----|----|
|2|3|6|0|
|9|7|4|5|
|8|-3|2|8|
|1|1|5|1|
|-1|-3|3||
|6|1|0|3|
|2|9|4|4|

