# concatDateTime {#concatdatetime}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`concatDateTime(date, time)`

Alias: concatDT

## Arguments {#arguments}

**date** is a scalar/vector of data type DATE.

**time** is a scalar/vector of data type SECOND, TIME or NANOTIME.

If *date* and *time* are both vector,s they must have the same length.

## Details {#details}

Combine *date* and *time* into one new variable.

If *time* is SECOND, return DATETIME.

If *time* is TIME, return TIMESTAMP.

If *time* is NANOTIME, return NANOTIMESTAMP.

## Examples {#examples}

```
concatDateTime(2019.06.15,13:25:10);
// output: 2019.06.15T13:25:10

concatDateTime(2019.06.15,[13:25:10, 13:25:12, 13:25:13]);
// output: [2019.06.15T13:25:10,2019.06.15T13:25:12,2019.06.15T13:25:13]

date=[2019.06.18, 2019.06.20, 2019.06.21, 2019.06.19, 2019.06.18, 2019.06.20]
time = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26]
sym = `C`MS`MS`MS`IBM`IBM$SYMBOL
price= 49.6 29.46 29.52 30.02 174.97 175.23
qty = 2200 1900 2100 3200 6800 5400
t = table(date, time, sym, qty, price);

select concatDateTime(date,time) as datetime, sym, qty, price from t;
```

|datetime|sym|qty|price|
|--------|---|---|-----|
|2019.06.18T09:34:07|C|2200|49.6|
|2019.06.20T09:36:42|MS|1900|29.46|
|2019.06.21T09:36:51|MS|2100|29.52|
|2019.06.19T09:36:59|MS|3200|30.02|
|2019.06.18T09:32:47|IBM|6800|174.97|
|2019.06.20T09:35:26|IBM|5400|175.23|

