# concat {#concat}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`concat(X, Y)`

## Arguments {#arguments}

**X** can be a STRING/CHAR scalar or vector.

**Y** can be a STRING/CHAR scalar.

If *X* or *Y* is not specified, it is treated as an empty string.

## Details {#details}

If *X* is a STRING/CHAR scalar

-   For an empty *X*,

    -   if *Y* is an empty STRING/CHAR scalar, the function returns an empty string.

    -   if *Y* is a non-empty STRING/CHAR scalar, the function returns *Y*.

-   Otherwise, the function forms a new string by combining *X* and *Y* regardless of whether *Y* is an empty string or not.


If *X* is a STRING/CHAR vector

-   For an empty *X*, the function returns an empty string.

-   Otherwise,

    -   if *Y* is an empty STRING/CHAR scalar, the function concatenates each element in *X* and returns a string object;

    -   if *Y* is a non-empty STRING/CHAR scalar, *Y* serves as the separator between the elements in vector *X* and the function returns a string object.


Note: The function *concat* implicitly converts all arguments to STRING type \(null values to empty strings\) before concatenation.

**Return value**: a STRING scalar

## Examples {#examples}

```
// join two strings
concat (`hello, `world);
// output: helloworld

// join IBM, GOOG and APPL with "," as the delimiter
x = concat(`IBM`GOOG`APPL, ",");
x;
// output: IBM,GOOG,APPL

typestr x;
// output: STRING

size x;
// output: 1

concat(string([]),"a")
// output: NULL

concat("55","")
// output: 55

// When Y is not specified, the function joins the elements of X to form a new string
concat(`a`b`c`d,)
// output: abcd
```

