# compress {#compress}

## Syntax {#syntax}

`compress(X, [method='lz4'])`

## Arguments {#arguments}

**X** is a vector or a table.

**method** \(optional\) is a string indicating the compression algorithm. The available options are:

-   "lz4" \(by default\) is suitable for almost all data types. Although the "lz4" method may not achieve the highest compression ratio, it provides fast compression and decompression speeds.

-   "delta" option applies delta-of-delta algorithm, which is particularly suitable for data types like SHORT, INT, LONG, and date/time data.

-   "zstd" is also suitable for almost all data types. It provides a higher compression ratio compared to "lz4", but the compression and decompression speed is about half as fast as "lz4".

-   "chimp" is suitable for DOUBLE type data with decimal parts not exceeding three digits in length.


## Details {#details}

Compress a vector or a table with the specified compression algorithm. The compressed variable needs to be decompressed with function [decompress](../d/decompress.md) before it can be used in a calculation.

## Examples {#examples}

```
x=1..100000000
y=compress(x, "delta");

y.typestr();
// output: HUGE COMPRESSED VECTOR

z=compress(x, "zstd");
z.typestr();
// output: HUGE COMPRESSED VECTOR

select name, bytes from objs() where name in `x`y;
```

|name|bytes|
|----|-----|
|x|402653952|
|y|13634544|

Please note that if function `size` is applied on the compressed vector y, the result is the length of the compressed vector y instead of the original vector x. To extract information about x from y, we need to decompress y first.

```
y.size();
// output: 12670932

z=decompress(y);
z.size();
// output: 100000000
```

Related functions: [decompress](../d/decompress.md)

