# complex {#complex}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`complex(X, Y)`

## Arguments {#arguments}

**X** and **Y** are numeric scalars, pairs, vectors or matrices. They can be of Integral \(excluding compress and INT128\) or Floating type.

## Details {#details}

Create a complex number `X+Y*i`.

The length of a complex number is 16 bytes. The low 8 bytes are stored in *X*, and the high 8 bytes are stored in *Y*.

## Examples {#examples}

```
complex(2, 5)
// output: 2.0+5.0i

a=1.0 2.3
b=3 4
complex(a,b)
```

|0|1|
|---|---|
|1.0+3.0i|2.3+4.0i|

Related functions: [highDouble](../h/highDouble.md), [lowDouble](../l/lowDouble.md)

