# coevent {#coevent}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`coevent(event, eventTime, window, [orderSensitive=false])`

## Arguments {#arguments}

**event** is a vector indicating events.

**eventTime** is a temporal or integer vector of the same length as event indicating the timestamps of events.

**window** is a non-negative integer indicating the length of an interval.

**orderSensitive** \(optional\) is a Boolean value indicating whether the order of the two events matters. The default value is false.

## Details {#details}

Count the number of occurrences of two events within the specified intervals.

Return a table with 3 columns: event1, event2 and hits. The values of event1 and event2 are based on the column event. Column hits is the number of occurrences of the event pair.

## Examples {#examples}

```
sensor_id=`A`B`C`D`C`A`B
time=[2012.06.13T12:30:00,2012.06.13T12:30:02,2012.06.13T12:30:04,2012.06.13T12:30:05,2012.06.13T12:30:06,2012.06.13T12:30:09,2012.06.13T12:30:10];

coevent(sensor_id, time, 2);
```

|event1|event2|hits|
|------|------|----|
|B|C|1|
|C|D|2|
|C|C|1|
|A|B|2|

```
coevent(sensor_id, time, 2, true);
```

|event1|event2|hits|
|------|------|----|
|C|C|1|
|B|C|1|
|C|D|1|
|D|C|1|
|A|B|2|

