# clearComputeNodeDiskCache {#clearcomputenodediskcache}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`clearComputeNodeDiskCache(database, [table], [partition])`

## Arguments {#arguments}

**database** is a string indicating the database name.

**table** \(optional\) is a string indicating the table name. It can contain the following wildcards:

-   "\*" \(default\): matches all;

-   "?": matches a single character;

-   "%": matches 0, 1 or more characters.


**partition** \(optional\) is a STRING scalar or vector indicating the DFS path of a partition. If *partition* is not specified, it indicates all partitions.

## Details {#details}

On a compute node in the compute group, invoke the function to clear the disk cache. Note that this operation cannot guarantee a complete cache clearing.

## Examples {#topic_lfs_pz4_1fc}

Clear the disk cache of the “database\_compute” database.

``` {#codeblock_pxh_rz4_1fc}
clearComputeNodeDiskCache("dfs://database_compute")      
```

Clear the disk cache of tables with the prefix of “pt” in the “database\_compute” database.

``` {#codeblock_ay2_sz4_1fc}
clearComputeNodeDiskCache("dfs://database_compute","pt%")           
```

