# clear! {#clear}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`clear!(X)`

## Arguments {#arguments}

**X** can be a vector, matrix, set, dictionary, or in-memory table.

## Details {#details}

Clear the contents of *X*. After execution *X* still exists. It retains its initial data type and can be appended with new data.

## Examples {#examples}

```
x=1 2 3;
clear!(x);
// output: []

typestr x;
// output: FAST INT VECTOR

size x;
// output: 0

x.append!(1..6);
// output: [1,2,3,4,5,6]

y=set(8 9 4 6);
y.clear!();
// output: set()

x=1..3;
y=4..6;
z=dict(x,y);
z;
/* output
3->6
1->4
2->5
*/
z.clear!();

t = table(1 2 3 as id, 1.0 2.0 3.0 as value)
t.clear!()
```

