# cj {#cj}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cj(X, Y)`

## Arguments {#arguments}

**X** and **Y** are tables.

## Details {#details}

Perform a cross join between two tables and returns their Cartesian product. If *X* has n rows and *Y* has m rows, then cj\(X,Y\) has n\*m rows.

## Examples {#examples}

```
a=table(1..3 as x,`IBM`C`AAPL as y)
b=table(172.3 25 106.5 as z)
c=cj(a,b);
c;
```

|x|y|z|
|---|---|---|
|1|IBM|172.3|
|1|IBM|25|
|1|IBM|106.5|
|2|C|172.3|
|2|C|25|
|2|C|106.5|
|3|AAPL|172.3|
|3|AAPL|25|
|3|AAPL|106.5|

```
// in contrast, the join (<-) operation simply merges two tables' columns
a join b;
```

|x|y|z|
|---|---|---|
|1|IBM|172.3|
|2|C|25|
|3|AAPL|106.5|

