# chiSquareTest {#chisquaretest}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`chiSquareTest(X, [Y])`

## Arguments {#arguments}

**X** is a numeric vector/matrix/table.

If *X* is a vector, *Y* is a numeric vector of the same length as *X*. *Y* is not required if *X* is not a vector.

## Details {#details}

If *X* is a vector, conduct a Chi-squared goodness of fit test whether *X* and *Y* follow the same distribution.

If *X* is a matrix/table, conduct Pearson's Chi-squared test on *X*.

Return a dictionary with the following keys:

-   pValue: p-value of the test

-   df: degree of freedom

-   chiSquaredValue: Chi-squared test statistic

-   method: either "Chi-square goodness of fit test" or "Pearson's Chi-squared test"


## Examples {#examples}

Example 1. *X* is a vector.

```
x=rand(10.0,50)
y=rand(10.0,50)
chiSquareTest(x,y);

/* output
pValue->0
df->49
chiSquaredValue->947.388015
method->Chi-square goodness of fit test
*/
```

Example 2. *X* is a matrix.

```
x = matrix([762, 484], [327, 239], [468, 477])
x.rename!(`female`male, `Democrat`Independent`Republican)
x;
```

||Democrat|Independent|Republican|
|---|--------|-----------|----------|
|female|762|327|468|
|male|484|239|477|

```
chiSquareTest(x);
/* output
pValue->2.953589E-7
df->2
chiSquaredValue->30.070149
method->Pearson's Chi-squared test
*/
```

