# cells {#cells}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cells(obj, row, col)`

## Arguments {#arguments}

**obj** is a matrix.

**row** is a vector of integral type, indicating indices of rows.

**col** is a vector of integral type of the same length as row, indicating indices of columns.

## Details {#details}

Return a vector of cells in a matrix by the specified row and column index.

## Examples {#examples}

```
m=(1..15).reshape(3:5)
m;
```

|col1|col2|col3|col4|col5|
|----|----|----|----|----|
|1|4|7|10|13|
|2|5|8|11|14|
|3|6|9|12|15|

```
// obtain the two elements at [0,1] and [0,2]
cells(m, 0 0, 1 2)
// output: [4,7]

// obtain the elements on the diagonal of the matrix
index = 0..2
cells(m, index, index)
// output: [1, 5, 9]
```

