# cell {#cell}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cell(obj, row, col)`

## Arguments {#arguments}

**obj** is a matrix or table.

**row** is a non-negative integer indicating a column number.

**col** is a non-negative integer indicating a row number.

## Details {#details}

Return a scalar that is the value of the specified cell: `obj[row, col]`. The `cell` function runs generally faster than `obj[row, col]`.

## Examples {#examples}

```
x=(1..6).reshape(3:2);
x;
```

|0|1|
|---|---|
|1|4|
|2|5|
|3|6|

```
x.cell(0,0);
// output: 1
x.cell(0,1);
// output: 4
cell(x,1,1);
// output: 5
cell(x,2,0);
// output: 3
```

