# ceil {#ceil}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ceil(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix.

## Details {#details}

Functions [floor](../f/floor.md) and `ceil` map a real number to the largest previous and the smallest following integer, respectively. Function [round](../r/round.md) maps a real number to the largest previous or the smallest following integer with the round half up rule.

## Examples {#examples}

```
ceil(2.1);
// output: 3
ceil(2.9);
// output: 3
ceil(-2.1);
// output: -2

floor(2.1);
// output: 2
floor(2.9);
// output: 2
floor(-2.1);
// output: -3

round(2.1);
// output: 2
round(2.9);
// output: 3
round(-2.1);
// output: -2

m = 1.1 2.2 3.3 4.4 5.5 6.6 7.7 8.8 9.9 10$2:5;
m;
```

|0|1|2|3|4|
|---|---|---|---|---|
|1.1|3.3|5.5|7.7|9.9|
|2.2|4.4|6.6|8.8|10|

```
ceil(m);
```

|0|1|2|3|4|
|---|---|---|---|---|
|2|4|6|8|10|
|3|5|7|9|10|

