# cancelJob {#canceljob}

## Syntax {#syntax}

`cancelJob(jobId)`

## Arguments {#arguments}

**jobId** is the batch job ID\(s\). It is a STRING scalar or vector. If it is a vector, multiple batch jobs are canceled at the same time.

## Details {#details}

Cancel submitted but unfinished batch job\(s\).

Starting from version 1.30.192.00.7, if a *jobId* does not exist when `cancelJob` is executed, the system no longer throws an exception. Instead, it outputs the error message with *jobId* to the log.

Version 1.30.232.00.11 has enhanced access control on job cancellation:

-   Administrators \(including admin and super admin\) can cancel batch jobs submitted by any user.

-   Regular users are only allowed to cancel batch jobs submitted by themselves.


## Examples {#examples}

```
def writeData(num){
   n=10
   month=take(2000.01M..2016.12M, n)
   x=rand(1.0, n)
   tt=table(month, x)
   if(existsDatabase("dfs://test_db")){
       dropDatabase("dfs://test_db")
   }
   db=database("dfs://test_db", VALUE, 2000.01M..2016.12M)
   pt = db.createPartitionedTable(tt, `pt, `month)
   for(x in 1..num){
       pt.append!(tt)
       sleep(1000)
   }
}

myJobId="writeData"+temporalFormat(datetime(now()),"yyyyMMddHHmmss")
submitJob(myJobId,"write data to dfs table",writeData,120);
cancelJob(myJobId);
```

Cancel the unfinished jobs in a cluster:

```
def cancelAllBatchJob(){
   jobids=exec jobid from getRecentJobs() where endTime=NULL
   cancelJob(jobids)
}
pnodeRun(cancelAllBatchJob)
```

