# cachedTable {#cachedtable}

## Syntax {#syntax}

`cachedTable(updateFunc, retentionSeconds)`

## Arguments {#arguments}

**updateFunc** is a function without parameters. It must return a table.

**retentionSeconds** is a positive integer indicating the frequency \(in seconds\) to update the cached table.

## Details {#details}

Create a special type of in-memory table: cached table. When querying the cached table, if the time elapsed since the last update exceeds a specified value, *updateFunc* is executed automatically to update the cached table.

To access a cached table with multiple threads, the table must be shared.

## Examples {#examples}

This example defines a unary function, `f1`, and fixes its argument to produce a partial application with no arguments, `f1{t}`. `f1{t}` is passed as the *updateFunc* to `cachedTable`.

```
def f1(mutable t){
    update t set id=id+1
    return t
}
t=table(1..5 as id, 15 25 35 45 55 as val)
ct=cachedTable(f1{t}, 2);

select * from ct;
```

|id|val|
|---|---|
|2|15|
|3|25|
|4|35|
|5|45|
|6|55|

```
sleep(2100)
select * from ct
```

|id|val|
|---|---|
|3|15|
|4|25|
|5|35|
|6|45|
|7|55|

```
ct=NULL;
```

