# cacheDS! {#cacheds}

## Syntax {#syntax}

`cacheDS!(ds)`

## Arguments {#arguments}

**ds** is a data source or a list of data sources.

## Details {#details}

Instruct the system to cache the data source when it is executed next time. It returns true or false to indicate if this operation is successful.

## Examples {#examples}

```
PTNDB_DIR = "/home/db_testing"
dbName = database(PTNDB_DIR + "/NYSETAQByName")
Trades = dbName.loadTable(`Trades)

ds=sqlDS(<select Time,Exchange,Symbol,Trade_Volume as Vol, Trade_Price as Price from Trades>)
ds.cacheDS!()        //cache the data
ds.clearDSCache!()   //clear the cache
```

