# businessYearBegin {#businessyearbegin}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`businessYearBegin(X, [startingMonth=1], [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector of data type DATE, DATEHOUR, DATETIME, TIMESTAMP or NANOTIMESTAMP.

**startingMonth** \(optional\) is an integer between 1 and 12 indicating a month. The default value is 1.

**offset** \(optional\) is a scalar of the same data type as *X*, It must be no greater than the minimum value of *X*. The default value is the minimum value of *X*.

**n** \(optional\) is a positive integer. The default value is 1.

## Details {#details}

Return the first business day \(Monday to Friday\) of the year that *X* belongs to and that starts in the month of *startingMonth*.

If parameter *offset* is specified, the result is updated every *n* years. The parameters *offset* and *n* must be specified together, and *offset* takes effect only when *n* &gt; 1.

## Examples {#examples}

```
businessYearBegin(2012.06.12);
// output: 2012.01.02

businessYearBegin(2012.06.13 10:10:10.008,5);
// output: 2012.05.01

date=2011.10.25 2012.10.25 2013.10.25 2014.10.25 2015.10.25 2016.10.25 2017.10.25 2018.10.25 2019.10.25 2020.10.25
time = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12,09:38:13]
sym = take(`MSFT,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, time, sym, qty, price);

select avg(price),sum(qty) from t1 group by businessYearBegin(date,1,2011.10.01,2)
```

|businessYearBegin\_date|avg\_price|sum\_qty|
|-----------------------|----------|--------|
|2011.01.03|39.53|4100|
|2013.01.01|29.77|5300|
|2015.01.01|175.1|12200|
|2017.01.02|50.54|3800|
|2019.01.01|51.835|13300|

Related functions: [businessYearEnd](businessYearEnd.md), [yearBegin](../y/yearBegin.md), [yearEnd](../y/yearEnd.md)

