# businessQuarterEnd {#businessquarterend}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`businessQuarterEnd(X, [endingMonth=12], [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector of data type DATE, DATEHOUR, DATETIME, TIMESTAMP or NANOTIMESTAMP.

**endingMonth** \(optional\) is an integer between 1 and 12 indicating a month. The default value is 12.

**offset** \(optional\) is a scalar of the same data type as *X*, It must be no greater than the minimum value of *X*. The default value is the minimum value of *X*.

**n** \(optional\) is a positive integer. The default value is 1.

## Details {#details}

Return the last day of the quarter that *X* belongs to. The last months of the quarters are determined by *endingMonth*. Note that *endingMonth*=3 is equivalent to *endingMonth*=6, 9 or 12.

If parameter *offset* is specified, the result is updated every *n* quarters. The parameters *offset* and *n* must be specified together, and *offset* takes effect only when *n* &gt; 1.

## Examples {#examples}

```python
businessQuarterEnd(2012.04.12);
// output: 2012.06.30

businessQuarterEnd(2012.04.12, 2);
// output: 2012.05.31

businessQuarterEnd(2012.04.12, 8, 2011.08.01, 3);
// output: 2012.05.31

date=2011.04.25+(1..10)*90
time = take(09:30:00, 10)
sym = take(`MSFT,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, time, sym, qty, price);

t1;
```

|date|time|sym|qty|price|
|----|----|---|---|-----|
|2011.07.24|09:30:00|MSFT|2200|49.6|
|2011.10.22|09:30:00|MSFT|1900|29.46|
|2012.01.20|09:30:00|MSFT|2100|29.52|
|2012.04.19|09:30:00|MSFT|3200|30.02|
|2012.07.18|09:30:00|MSFT|6800|174.97|
|2012.10.16|09:30:00|MSFT|5400|175.23|
|2013.01.14|09:30:00|MSFT|1300|50.76|
|2013.04.14|09:30:00|MSFT|2500|50.32|
|2013.07.13|09:30:00|MSFT|8800|51.29|
|2013.10.11|09:30:00|MSFT|4500|52.38|

```python
select avg(price),sum(qty) from t1 group by businessQuarterEnd(date, , 2010.06.01, 2)
```

|businessQuarterEnd\_date|avg\_price|sum\_qty|
|------------------------|----------|--------|
|2011.12.30|39.53|4100|
|2012.06.29|29.77|5300|
|2012.12.31|175.1|12200|
|2013.06.28|50.54|3800|
|2013.12.31|51.835|13300|

Related functions: [businessQuarterBegin](businessQuarterBegin.md), [quarterBegin](../q/quarterBegin.md), [quarterEnd](../q/quarterEnd.md)

