# bucketCount {#bucketcount}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`bucketCount(vector, dataRange, bucketNum, [includeOutbound=false])`

## Arguments {#arguments}

**vector** is a numeric or temporal vector.

**dataRange** is a pair indicating the data range, which includes the lower bound and excludes the upper bound.

**bucketNum** is the number of buckets. When *dataRange* is specified as an INT PAIR, its range must be a multiple of *bucketNum*.

**includeOutbound** \(optional\) is a Boolean value indicating whether to include the bucket below the lower bound of the data range and the bucket beyond the upper bound of the data range. The default value is false.

## Details {#details}

Accept the same set of parameters as the function [bucket](bucket.md) and return the count for each bucket.

## Examples {#examples}

```
bucketCount(9 23 54 36 46 12, 12:54, 2);
// output: [2,2]

bucketCount(9 23 54 36 46 12, 12:54, 2, 1);
// output: [1,2,2,1]
```

