# brute {#brute}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#topic_gpn_hpr_xbc}

`brute(func, ranges, [ns=20], [finish=fmin])`

## Details {#topic_ipn_hpr_xbc}

Minimize a function over a given range by brute force. Use the "brute force" method, i.e., compute the function's value at each point of a multidimensional grid of points, to find the global minimum of the function.

**Note:** The brute force approach is inefficient because the number of grid points increases exponentially. Consequently, even in cases where the grid spacing is coarse, or the problem is only of medium size, it can take a long time to run, and/or run into memory limitations.

## Arguments {#topic_hpn_hpr_xbc}

**func** is the name of the function to be minimized. Note that its return value must be a numeric scalar.

**ranges** is a tuple of tuples. Each tuple element can take the following forms:

-   \(low, high\): Specifies the minimum and maximum values for a parameter.

-   \(low, high, num\): Also includes the number of grid points between *low* and *high*.


**ns**\(optional\) is a positive number indicating the number of grid points along the axes. If *ranges* is specified as *\(low, high, num\)*, *num* determines the number of points. Otherwise, *ns* is used, defaulting to 20 if not provided.

**finish** \(optional\) is an optimization function that is called with the result of brute force minimization as initial guess. *finish* should be a function that returns a dictionary that contains keys 'xopt' and 'fopt' and their values should be numeric. The default value is the `fmin` function. If set to NULL, no "polishing" function is applied and the result of `brute` is returned directly.

## Return Values {#topic_bjq_jqr_xbc}

It returns a dictionary with the following members:

-   xopt: Parameter that minimizes function.

-   fopt: Value of function at minimum: `fopt = f(xopt)`.


## Examples {#topic_jpn_hpr_xbc}

Calculate the minimum of function `f` within *ranges*.

``` {#codeblock_vxh_mqr_xbc}
def f(z) {
	a = 2
	b = 3
	c = 7
	d = 8
	ee = 9
	f = 10
	g = 44
	h = -1
	i = 2
	j = 26
	k = 1
	l = -2
	scale = 0.5
	x = z[0]
	y = z[1]
	f1 = a * square(x) + b * x * y + c * square(y) + d * x + ee* y + f
	f2 = -g * exp(-(square(x-h)+square(y-i)) / scale)
	f3 =  -j * exp(-(square(x-k)+square(y-l)) / scale)
	return f1+f2+f3
}
ranges=((-4, 3.75),(-4, 3.75))
brute(f, ranges, 32)

/* Ouput:

fopt->-3.408581876799
xopt->[-1.056651921797,1.808348429512]

*/
```

