# boxcox {#boxcox}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`boxcox(X, [lmbda])`

## Arguments {#arguments}

**X** is a numeric vector representing the input to be transformed. If the *lmbda* parameter is not specified, *X*cannot contain null or non-positivevalues, and all elements cannot be identical.

**lmbda**\(optional\) is a numeric scalar or vector representing the lambda parameter. If it is a vector, *X* and *lmbda* must be of equal length.

## Details {#details}

This function transforms *X* by using the Box-Cox transformation method.

The Box-Cox transform is given by:

![](../images/boxcox.png)

**Return value:**

-   If the *lmbda* parameter is specified, the function returns a vector of DOUBLE type.
    -   if *lmbda* is a scalar, the result is the Box-Cox transformation of *X* using *lmbda*.
    -   if *lmbda* is a vector, the result is a vector where each element corresponds to `boxcox(Xi, lmbdai)`.
-   If the *lmbda* parameter is not specified, the function returns a 2-element tuple:
    -   The first element is a vector of DOUBLE type, representing the Box-Cox transformation of *X*.
    -   The second element is a scalar of DOUBLE type, representing the optimal lambda parameter.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
data = [1.5, 2.3, 3.1, 4.8, 5.5, 6.7, 8.2, 9.0, 10.1, 12.4]
lmb = 2
boxcox(data)

// output: ([0.4541,1.0562,1.5689,2.4892,2.82394,3.3559,3.9636,4.267,4.6653,5.4393],0.5495)

boxcox(data, lmb)
// output: [0.625,2.145,4.305,11.02,14.625,21.945,33.12,40,50.505,76.38]
```

