# bondFuturesPricer {#bondFuturesPricer}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`bondFuturesPricer(instrument, pricingDate, discountCurve)`

## Arguments {#arguments}

**instrument** is an INSTRUMENT scalar of BondFutures type indicating the bond futures to be priced.

**pricingDate** is a DATE scalar specifying the pricing date.

**discountCurve** is a MKTDATA scalar of type IrYieldCurve representing the discount curve.

## Details {#details}

Calculates the Net Present Value \(NPV\) of the bond futures.

**Return value**: A DOUBLE scalar.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
bond = {
    "productType": "Cash",
    "assetType": "Bond",
    "bondType": "FixedRateBond",
    "version": 0, 
    "instrumentId": "220010.IB",
    "start": "2022.05.15",
    "maturity": "2032.05.15",
    "issuePrice": 100.0,
    "coupon": 0.0276,
    "frequency": "Semiannual",
    "dayCountConvention": "ActualActualISDA"
}

bondFutures = { 
    "productType": "Futures",
    "futuresType": "BondFutures",
    "version": 0,
    "instrumentId": "T2509",
    "nominal": 100.0,
    "maturity": "2025.09.12",
    "settlement": "2025.09.16",
    "underlying": bond,
    "nominalCouponRate": 0.03
}

instrument = parseInstrument(bondFutures)
pricingDate = 2025.06.10
curve = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "referenceDate": pricingDate,
    "currency": "CNY",
    "dayCountConvention": "ActualActualISDA",
    "compounding": "Compounded",
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Semiannual",
    "dates":[2025.09.05, 2025.12.05, 2026.03.05, 2027.03.05, 2028.03.05, 2030.03.05, 2035.03.05, 2040.03.05, 2045.03.05, 2055.03.05, 2075.03.05],
    "values":[1.5347, 1.4958, 1.4447, 1.3955, 1.5029, 1.5561, 1.7156, 1.8652, 2.0329, 1.8955, 2.1059] / 100.0
}
discountCurve = parseMktData(curve)
npv = bondFuturesPricer(instrument, pricingDate, discountCurve)
print(npv)
// output:108.716241945330267
```

