# blob {#blob}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`blob(X)`

## Arguments {#arguments}

**X** is a STRING scalar/vector.

## Details {#details}

Convert the data type of *X* to BLOB.

**Note**: Values of BLOB type do not participate in calculations.

## Examples {#examples}

```
str="hello"
blob(str)
// output: hello

t=table(1..10 as id, "A"+string(1..10) as sym, 2012.01.01..2012.01.10 as date, rand(100.0, 10) as val, rand(uuid(), 10) as uid)
str=toJson(t)
blob(str)
```

After a long string is converted to BLOB, it can be used as a column of an in-memory table:

```
d = dict(1..10000,  rand(1.0, 10000))
str=toStdJson(d);
t=table(blob(str) as jsonStr)
```

The BLOB type is also supported by DFS tables.

```
dbPath="dfs://testBlobDB"
if(existsDatabase(dbPath)){
dropDatabase(dbPath)
}
n=2000000
t=table(n:0,`date`id`type`num`blob,[DATETIME,INT,SYMBOL,DOUBLE,BLOB])
db1=database("",VALUE,2020.01.01..2020.01.10)
db2=database("",HASH,[INT,10])

db=database(dbPath,COMPO,[db1,db2])
pt1=createPartitionedTable(db,t,`pt1,`date`id)

date=concatDateTime(take(2020.01.01..2020.01.10,n),take(00:00:00..23:23:59,n))
id=rand(1..1000,n)
type=rand(`A`B`C`D`E,n)
num=rand(100.0,n)

blob=take(blob(string(1..10)),n)

t1=table(date,id,type,num,blob)
pt1.append!(t1)
select *  from pt1
```

