# binaryExpr {#binaryexpr}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`binaryExpr(X, Y, optr)`

## Arguments {#arguments}

**X** can be a scalar/vector/matrix.

**Y** is a scalar or a vector of the same type as *X*.

**optr** is a binary operator.

## Details {#details}

Connect *X* and *Y* with the binary operator specified in *optr* to generate metacode of a binary expression. You can execute the metacode with function [eval](../e/eval.md).

## Examples {#examples}

```
binaryExpr(1, 1, +).eval()
// output: 2

binaryExpr(1 2.2 3, 1 2 3, *).eval()
// output: [1 4.4 9]

binaryExpr(`id`st`nm, `fff, +).eval()
// output: ["idfff","stfff","nmfff"]


a = matrix(1 2, 3 4)
b = matrix(4 2, 5 1)
binaryExpr(a, b, dot).eval()
```

|\#0|\#1|
|---|---|
|10|8|
|16|14|

Related function: [unifiedExpr](../u/unifiedExpr.md)

