# bfill {#bfill}

## Syntax {#syntax}

`bfill(obj, [limit])`

## Arguments {#arguments}

**obj** is a vector/matrix/table/array vector.

**limit** \(optional\) is a positive integer indicating the maximum number of consecutive null values to be filled. It cannot be specified when *obj* is an array vector.

## Details {#details}

-   If *obj* is a vector: back fill the null values in *obj* with the next non-null value.
-   If *obj* is an array vector:
    -   For an empty row, fill it with the first non-empty row that follows it.
    -   For null values in a column, fill them with the first non-null value that follows within the same column.
-   If *obj* is a matrix or a table: back fill the null values in each column of *obj*with the next non-null value. according to the above rules.

This operation creates a new object and does not change the input *obj*. Function [bfill!](bfill!.md) changes the input *obj*.

## Examples {#examples}

```
x=1 2 3 NULL NULL NULL 4 5 6
x.bfill();
// output: [1,2,3,4,4,4,4,5,6]

x=1 2 3 NULL NULL NULL 4 5 6
x.bfill(1);
// output: [1,2,3,,,4,4,5,6]

x.bfill!(2);
x;
// output: [1,2,3,,4,4,4,5,6]

date=[2012.06.12,2012.06.12,2012.06.13,2012.06.14,2012.06.15]
sym=["IBM","MSFT","IBM","MSFT","MSFT"]
price=[,,26.56,,50.76]
qty=[,,4500,5600,6800]
timestamp=[09:34:07,09:35:26,09:36:42,09:36:51,09:36:59]
t=table(date,timestamp,sym,price,qty)
t;
```

|date|timestamp|sym|price|qty|
|----|---------|---|-----|---|
|2012.06.12|09:34:07|IBM|||
|2012.06.12|09:35:26|MSFT|||
|2012.06.13|09:36:42|IBM|26.56|4500|
|2012.06.14|09:36:51|MSFT||5600|
|2012.06.15|09:36:59|MSFT|50.76|6800|

```
t.bfill()
```

|date|timestamp|sym|price|qty|
|----|---------|---|-----|---|
|2012.06.12|09:34:07|IBM|26.56|4500|
|2012.06.12|09:35:26|MSFT|26.56|4500|
|2012.06.13|09:36:42|IBM|26.56|4500|
|2012.06.14|09:36:51|MSFT|50.76|5600|
|2012.06.15|09:36:59|MSFT|50.76|6800|

```
select date, timestamp, sym, price.bfill() as price, qty.bfill() as qty from t context by sym;
```

|date|timestamp|sym|price|qty|
|----|---------|---|-----|---|
|2012.06.12|09:34:07|IBM|26.56|4500|
|2012.06.13|09:36:42|IBM|26.56|4500|
|2012.06.12|09:35:26|MSFT|50.76|5600|
|2012.06.14|09:36:51|MSFT|50.76|5600|
|2012.06.15|09:36:59|MSFT|50.76|6800|

In the following example, the third row of the array vector x is empty, so it is filled with the fourth row \[8, 9, 10\]; the first element of the third column is null, so it is filled with the next non-null value 10 in that column.

``` {#codeblock_v4h_ctb_d2c}
x = array(INT[], 0).append!([1 2 NULL, 4 5, NULL, 8 9 10])
x
// output:[[1,2,NULL],[4,5],[NULL],[8,9,10]]
bfill(x)
// output:[[1,2,10],[4,5],[8,9,10],[8,9,10]]
```

