# bfill! {#bfill}

## Syntax {#syntax}

`bfill!(obj, [limit])`

## Arguments {#arguments}

**obj** is a vector, matrix, or table.

**limit** \(optional\) is a positive integer indicating the number of null values to be filled.

## Details {#details}

-   If *obj* is a vector: back fill the null values in *obj* with the next non-null value.

-   If *obj* is a matrix or a table: back fill the null values in each column of *obj* with the next non-null value.


## Examples {#examples}

```
x=1 2 3 NULL NULL NULL 4 5 6
x.bfill!()
x;
// output: [1,2,3,4,4,4,4,5,6]

x=1 2 3 NULL NULL NULL 4 5 6
x.bfill!(1)
x;
// output: [1,2,3,,,4,4,5,6]

date=[2012.06.12,,2012.06.13,2012.06.14,2012.06.15]
sym=["IBM","MSFT","IBM","MSFT","MSFT"]
price=[40.56,26.56,,,50.76]
qty=[2200,4500,1200,5600,]
timestamp=[09:34:07,,09:36:42,09:36:51,09:36:59]
t=table(date,timestamp,sym,price,qty)

bfill!(t)
t
```

|date|timestamp|sym|price|qty|
|----|---------|---|-----|---|
|2012.06.12|09:34:07|IBM|40.56|2200|
|2012.06.13|09:36:42|MSFT|26.56|4500|
|2012.06.13|09:36:42|IBM|50.76|1200|
|2012.06.14|09:36:51|MSFT|50.76|5600|
|2012.06.15|09:36:59|MSFT|50.76||

If only certain columns need to be filled instead of all columns, please use [update](../../Programming/SQLStatements/update.md) statement and [bfill](bfill.md) function. For details, please refer to [bfill](bfill.md).

