# between {#between}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`between(X, Y)`

## Arguments {#arguments}

**X** is a scalar/pair/vector/matrix.

**Y** is a pair indicating a range.

## Details {#details}

Check if each element of *X* is between the pair indicated by *Y* \(both boundaries are inclusive\). The result is of the same dimension as *X*.

## Examples {#examples}

```
between([1, 5.5, 6, 8], 1:6);
// output: [1,1,1,0] // 1, 5.5 and 6 are between 1 and 6, but 8 is not.

between(1 2.4 3.6 2 3.9, 2.4:3.6);
// output: [0,1,1,0,0]
```

`between` can be used with `select` to filter columns:

``` {#codeblock_rjn_cpf_dzb}
t = table(`abb`aac`aaa as sym, 1.8 2.3 3.7 as price);
select * from t where price between 1:3;
```

<table id="table_dh4_2pf_dzb"><tbody><tr><td>

sym

</td><td>

price

</td></tr><tr><td>

abb

</td><td>

1.8

</td></tr><tr><td>

aac

</td><td>

2.3

</td></tr></tbody>
</table>The following example explains how null values of *Y* are handled.

If the configuration parameter *nullAsMinValueForComparison* is set to true, null values are treated as the minimum value of the current data type. Otherwise null values are processed as NULL and the comparison returns NULL.

`between` can also be used with template [nullCompare](../Templates/nullCompare.md), and the result of comparison involving null values is always NULL, regardless of the *nullAsMinValueForComparison* setting.

``` {#pre_ecw_c1w_gzb}
between(10,:10)
// output: true      // when nullAsMinValueForComparison=true

between(10,:10)
// output: NULL     // when nullAsMinValueForComparison=false

nullCompare(between, 10, :10)
// output: NULL
```

