# backupSettings {#backupSettings}

## Syntax {#Syntax .section}

`backupSettings(fileName, [userPermission=true], [functionView=true])`

## Arguments {#Arguments .section}

**fileName**is a STRING scalar specifying the backup file path. It can be an absolute path or relative path to *&lt;HomeDir&gt;*.

**userPermission** \(optional\) is a Boolean scalar, indicating whether to back up user permissions. The default value is true.

**functionView** \(optional\) is a Boolean scalar, indicating whether to back up function views. The default value is true.

## Details {#Details .section}

Back up all settings on users, permissions, and function views to specified directory.

This function can only be executed by an administrator on the controller. It can be used with `restoreSettings` to back up and restore user settings when migrating databases.

**Return value**: A vector containing all backup user names and function views.

## Examples {#section_kmq_4lw_nbc .section}

``` {#codeblock_o5s_plw_nbc}
backupSettings(fileName="/home/ddb/backup/permission.back", userPermission=true, functionView=true)
backupSettings(fileName="/home/ddb/backup/permission.back", userPermission=true, functionView=false)
backupSettings(fileName="/home/ddb/backup/permission.back", userPermission=false, functionView=true)
backupSettings(fileName="/home/ddb/backup/permission.back", userPermission=false, functionView=false)
```

**Related function**: [restoreSettings](../r/restoreSettings.md)

**Parent topic:**[Functions](../../Functions/category.md)

