# autocorr {#autocorr}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`autocorr(X, lag)`

## Arguments {#arguments}

**location** is a vector.

**lag** is a positive integer.

## Details {#details}

Calculate the autocorrelation of *X*. Note that the means of the two time series used in the calculation is the mean of *X* instead of the means of the two time series.

## Examples {#examples}

```
n=10000
x=array(double, n, n, NULL)
x[0]=1
r=rand(0.05, n)-0.025
for(i in 0:(n-1)){
    x[i+1]=-0.8*x[i]+r[i]
}

autocorr(x, 1)
// output: -0.808343

autocorr(x, 2)
// output: 0.661018
```

