# at {#at}

## Syntax {#syntax}

`at(X, [index])`

## Arguments {#arguments}

If only one parameter is specified:

-   **X** is a Boolean expression/vector or an integer vector.

If both parameters are specified:

-   **X** is a scalar/vector \(including tuplesand array vectors\)/matrix/table/dictionary/pair/function;
-   **index** is a Boolean expression/Boolean value/scalar/vector \(including tuplesand array vectors\)/pair.

## Details {#details}

In the first case:

-   If *X* is a Boolean expression/vector, `at` returns the indexes of the elements of *X* that are true.

-   If *X* is an integer vector, `at` returns a vector where each index in *X* is repeated according to its corresponding value. Its functionality is equivalent to `take(til(count(X)), X)`. For example, `at(3 0 2)` returns `[0,0,0,2,2]`. If a value at some position is non-positive, that position is skipped.


In the second case:

-   If *index* is a Boolean expression, `at` returns the elements in *X* that correspond to the elements in *Y* that are true. Function `at` is equivalent to brackets operator `[]`. For example, `X.at(X>3)` is equivalent to `X[X>3]`.

-   If *index* is a vector, `at` retrieves the elements from *X* at the positions as specified by each element of *index*.

-   If *index* is a tuple, each element in the tuple specifies an index into the corresponding dimension of *X*. `at` retrieves the element\(s\) at the specified position as specified by the indices. For example, when *X* is a matrix, *index* must be a tuple of two elements - the first element indicates the row index, and the second element indicates the column index.

-   If *index* is a pair like a:b, `at` returns the elements from *X* in the range \[a,b\).

-   If *index* is an array vector, each row of index specifies indices to retrieve from *X*. The result is an array vector with the same dimension as *index*.


Note: When *index* refers to column/row index, or an index range, for elements outside the bounds of the *X* \(i.e. outside of \[0, size\(X\)-1\]\), the corresponding positions in *X* will return null values.

If *X* is a function, *index* specifies the arguments of *X*. When*index* is a tuple, each element of the tuple is passed as an argument to *X*.

## Examples {#examples}

```
x = 2 3 -1 0 1
at(x)
// output:[0,0,1,1,1,4]

x=5 7 0 4 2 3
at(x>3)
// output: [0,1,3] 
// at position 0, 1, and 3, x>3 is true.

// compare with x>3:
x>3;
// output: [1,1,0,1,0,0]

x[x>3]
// output: [5,7,4]

x at x>3
// output: [5,7,4]

x=5 7 0 0 0 3
at(x==0)
// output: [2,3,4]

x[x==0]
// output: [0,0,0]

shares=500 1000 1000 600 2000
prices=25.5 97.5  19.2 38.4 101.5
prices[shares>800]
// output: [97.5,19.2,101.5]

prices at shares>800
// output: [97.5,19.2,101.5]

m=(1..6).reshape(2:3)
m;
```

|0|1|2|
|---|---|---|
|1|3|5|
|2|4|6|

```
at(m>3)
// output: [3,4,5]

m[m>3] // equal to m at m>3
```

|col1|col2|col3|
|----|----|----|
|||5|
||4|6|

Note the difference between using a vector versus a tuple for *index*:

```
m at [0,2]  // locate column 0 and 2
```

|0|1|
|---|---|
|1|5|
|2|6|

```
m at (0,2) // locate element at a specific column and a specific row
// output: 5
```

```
m at 0:2  // locate column 0 and 1
```

|0|1|
|---|---|
|1|3|
|2|4|

When *index* is an array vector:

```
a = array\(INT\[\], 0, 10\).append!\(\[0 2 3, 0 5, 0 8 8, 9 10\]\)
b =\[1, 2, 3\]

at\(b, a\)
// output: \[\[1,3, \], \[1, \], \[1, , \], \[ , \]\]

at\(a,a&gt;3\)
// output: \[,\[5\],\[8,8\],\[9,10\]\]
```

When *X*is a function, and *index* is a tuple to be passed as an argument:

``` {#codeblock_lkp_g21_bbc}
score = (60, 70);
at(add,score)
//output: 130
```

