# arrayVector {#arrayvector}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`arrayVector(index, value)`

## Arguments {#arguments}

**index** is a vector of positive integers, which must be strictly monotonically increasing.

**value** is a vector. Its data type must be supported by [arrayVector](../../Programming/DataTypesandStructures/DataForms/Vector/arrayVector.md)

## Details {#details}

Convert *value* into an array vector by spliting it based on the elements in *index*. The number of elements in *index* indicates the number of rows of array vector. Each element in *index* corresponds to the position in *value* \(starting from 1\), which is the last element of each new vector. See how an array vector is converted in the following figure:

![](../../images/arrayVector01.png)

Note: The maximum value in *index* can be no greater than the length of *value*.

## Examples {#examples}

```
arrayVector(2 3 4, [1,2,3,4])
// output: [[1,2],[3],[4]]

arrayVector(1 4 7, [1.0,2.1,4.1,6.8,0.5,2.2,2])
// output: [[1],[2.1,4.1,6.8],[0.5,2.2,2]]

value = 2022.01.01 + 0..20
index = 7 14 21
arrayVector(index, value)
// output: [[2022.01.01,2022.01.02,2022.01.03,2022.01.04,2022.01.05,2022.01.06,2022.01.07],[2022.01.08,2022.01.09,2022.01.10,2022.01.11,2022.01.12,2022.01.13,2022.01.14],[2022.01.15,2022.01.16,2022.01.17,2022.01.18,2022.01.19,2022.01.20,2022.01.21]]
```

Related function: [fixedLengthArrayVector](../f/fixedLengthArrayVector.md)

