# array {#array}

## Syntax {#syntax}

`array(dataType|template, [initialSize], [capacity], [defaultValue])`

## Arguments {#arguments}

**dataType** is the data type for the vector.

**template** is an existing vector. The existing vector serves as a template and its data type determines the new vector's data type.

**initialSize** \(optional\) is the initial size \(in terms of the number of elements\) of the vector.

**capacity** \(optional\) is the amount of memory \(in terms of the number of elements\) allocated to the array. When the number of elements exceeds capacity, the system will first allocate memory of 1.2~2 times of capacity, copy the data to the new memory space, and release the original memory.

**defaultValue** \(optional\) is the default value of the vector. It must be a scalar. If *defaultValue* is not specified, it defaults to NULL for STRING and SYMBOL values, and 0 for other data types.

## Details {#details}

Return a vector.

## Examples {#examples}

```
x=array(int, 10, 100, 1) // initial size is 10; capacity is 100; default value is 1
x
// output: [1,1,1,1,1,1,1,1,1,1]

x=array(int, 0) // initialize an empty vector
x
// output: []

x.append!(1..10)
// output: [1,2,3,4,5,6,7,8,9,10]

y=array(x)
y
// output: [0,0,0,0,0,0,0,0,0,0]

syms=array(symbol, 0, 100) // an empty symbol vector with capacity of 100
typestr syms
// output: FAST SYMBOL VECTOR
```

