# arima {#arima}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`arima(ds, endogColName, order, [seasonalOrder], [exog], [trend], [enforceStationarity=true], [enforceInvertibility=true], [concentrateScale=false], [trendOffset=1])`

## Arguments {#arguments}

**ds** is an in-memory table or a list of data sources containing the univariate time series data for analysis.

**endogColName** is a string specifying the column name in *ds* that contains the univariate time series to be analyzed.

**order** is a vector of three non-negative integers representing the \(p,d,q\) order of the ARIMA model for the autoregressive \(AR\), differences, and moving average \(MA\) components.

**seasonalOrder** \(optional\) is a vector of four non-negative integers representing the \(P, D, Q, s\) order of the seasonal ARIMA model for the AR parameters, differences, MA parameters, and periodicity. The default value is \[0, 0, 0, 0\], indicating no seasonality.

**exog** \(optional\) is a numerical matrix representing exogenous variables. Each column of the matrix represents the time series data of an exogenous variable, and the number of rows must equal the number of rows in *ds*.

**trend** \(optional\) is a string used to control the deterministic trend. It can be

-   'n' - no constant or trend \(default if *d* &gt; 0 or D &gt; 0\)
-   'c' - only constant \(default if *d* = 0 and D = 0\)
-   't' - only linear trend
-   'ct' - constant and linear trend

**enforceStationarity**\(optional\) is a boolean scalar indicating whether to enforce stationarity on the AR component. The default value is true.

**enforceInvertibility**\(optional\) is a boolean scalar indicating whether to enforce invertibility on the MA component. The default value is true.

**concentrateScale**\(optional\) is a boolean scalar indicating whether to concentrate the scale \(variance of the error term\) out of the likelihood, which reduces the number of estimated parameters by one. Applicable only when considering estimation by numerical maximum likelihood. The default value is false.

**trendOffset** \(optional\) is an integer specifying the offset at which to start time trend values. The default value is 1, so if *trend*='t', the trend values will be 1, 2, ..., nobs.

**maxIter**\(optional\) is a positive integer indicating the maximum number of iterations. The default value is 500.

## Details {#details}

The Autoregressive Integrated Moving Average \(ARIMA\) model is used to analyze univariate time series, which consists of three main components: autoregressive \(AR\), integrated \(I\), and moving average \(MA\).

The `arima` function is used for ARIMA-like modeling and can be used to construct the following time series analysis models:

-   Autoregressive model, *AR*: Captures the relationship between data and its historical values.
-   Moving Average model, *MA*: Focuses on handling random fluctuations.
-   Autoregressive Moving Average model, *ARMA*: Combines AR and MA components.
-   Autoregressive Integrated Moving Average model,*ARIMA*
-   Seasonal model, *SARIMA*: Handles data with periodic patterns.
-   Regression with errors, *ARIMAX*: Incorporates external regressors with error terms modeled by ARIMA-like structures.

**Return value**: A dictionary representing the analysis results of the ARIMA model with the following keys:

-   params: A vector of floating-point numbers representing the parameters estimated by the ARIMA model.
-   llf: A floating-point scalar representing the log-likelihood value of the ARIMA model.
-   aic: A floating-point scalar representing the Akaike Information Criterion.
-   bic: A floating-point scalar representing the Bayesian Information Criterion.
-   hqic: A floating-point scalar representing the Hannan-Quinn Information Criterion.

## Examples {#examples}

The following script uses quarterly economic indicator data from 1959 to 2009 to fit an ARIMA model to real GDP \(`realgdp`\). Based on analysis, it is assumed that the appropriate model is ARIMA\(1,0,0\), meaning an autoregressive model with order 1, no differencing, and no moving average component.

``` {#codeblock_zq1_tms_c2c}
data = loadText("./macrodata.csv")
res = arima(data, "realgdp", [1,0,0]);
res;
/* 
params->[0.007795600187477,0.306055792984419,0.000069811276429]
llf->679.783769203580163
aic->-1353.567538407160327
bic->-1343.64273531495678
hqic->-1349.551945119058927
*/
```

[macrodata.csv](../resources/arima/macrodata.csv)

