# appendTuple! {#appendtuple}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`appendTuple!(X, Y, [wholistic=false])`

## Arguments {#argument}

**X** is a tuple.

**Y** is a tuple.

**wholistic** is a Boolean. The default value is false.

## Details {#details}

Append *Y* to *X*:

-   If *wholistic* = true, *Y* is appended as one tuple element;

-   If *wholistic*= false, each element of *Y* is appended independently.


If *X* is a columnar tuple, *wholistic* must be set to false, and the elements of *Y* must have the same data type as those of *X*.

## Examples {#examples}

```python
$ x = (1,"X")
$ y = ([2,3],"Y")
$ x.appendTuple!(y,true)
$ print(x)
// output: (1,"X",([2,3],"Y"))

$ x.appendTuple!(y,false)
$ print(x)
// output: (1,"X",([2,3],"Y"),[2,3],"Y")

$ x = [[1,2,3],4]
$ x.setColumnarTuple!()
$ x.appendTuple!((5,6),false)
$ print(x)
// output: ([1,2,3],4,5,6)
```

