# appendForJoin {#appendforjoin}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`appendForJoin(engine, isLeftTable, data)`

## Arguments {#arguments}

**engine** is a streaming join engine, which is the abstract table object returned by function `createAsofJoinEngine`, `createEquiJoinEngine`, `createWindowJoinEngine`, `createLeftSemiJoinEngine`, or `createLookupJoinEngine`.

**isLeftTable** is a Boolean value indicating whether to insert into the left table or right table.

**data** is the data to be ingested into the streaming engine.

## Details {#details}

Insert data into a streaming join engine.

Please note that the parameter *handler* of function [subscribeTable](../s/subscribeTable.md) must be `appendForJoin`, [getLeftStream](../g/getLeftStream.md), or [getRightStream](../g/getRightStream.md) while subscribing to a stream table of a streaming join engine.

## Examples {#examples}

```
leftTable=table(1:0, `timestamp`sym`price, [TIMESTAMP, SYMBOL, DOUBLE])
rightTable=table(1:0, `timestamp`sym`val, [TIMESTAMP, SYMBOL, DOUBLE])
output=table(100:0, `timestamp`sym`price`val`total, [TIMESTAMP, SYMBOL, DOUBLE, DOUBLE, DOUBLE])
ajEngine=createAsofJoinEngine("test1", leftTable, rightTable, output, <[price, val, price*val]>, `sym, `timestamp, false, 7)

tmp1=table(take(2012.01.01T00:00:00.000+[1, 2, 3, 4, 5, 6, 7, 8, 9, 10], 20) as timestamp, take(`AAPL, 10) join take(`IBM, 10) as sym, double(1..20) as price)
tmp2=table(take(2012.01.01T00:00:00.000+[1, 2, 3, 4, 4, 4, 4, 4, 4, 4], 20) as timestamp, take(`AAPL, 10) join take(`IBM, 10) as sym, double(1..20) as val)

appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.001))
appendForJoin(ajEngine, false, (select * from tmp2 where timestamp=2012.01.01T00:00:00.001))
appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.002))
appendForJoin(ajEngine, false, (select * from tmp2 where timestamp=2012.01.01T00:00:00.002))
appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.003))
appendForJoin(ajEngine, false, (select * from tmp2 where timestamp=2012.01.01T00:00:00.003))
appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.004))
appendForJoin(ajEngine, false, (select * from tmp2 where timestamp=2012.01.01T00:00:00.004))
appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.005))
appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.006))
appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.007))
appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.008))
appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.009))
appendForJoin(ajEngine, true, (select * from tmp1 where timestamp=2012.01.01T00:00:00.010))

sleep(5000)
```

