# anova {#anova}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`anova(X)`

## Arguments {#arguments}

**X** is a matrix or a table with numeric columns.

## Details {#details}

Conduct one-way analysis of variance \(ANOVA\). Each column in *X* is a group.

Return a dictionary with the following keys:

-   pValue: p-value of the F-statistic
-   fValue: F-statistic
-   ssBetween: sum of squares between groups
-   dfBetween: degrees of freedom between groups
-   ssWithin: sum of squares within groups
-   dfWithin: degrees of freedom for each group

## Examples {#examples}

```
a=300 287 301 400 211 399 412 312 390 412
b=240 259 302 311 210 402 390 298 347 380
c=210 230 213 210 220 208 290 300 201 201
m=matrix(a,b,c)
anova(m);

/* output
pValue->0.000515
fValue->10.15459
ssBetween->70528.066667
dfBetween->2
ssWithin->93763.4
dfWithin->27
*/
```

