# addValuePartitions {#addvaluepartitions}

## Syntax {#syntax}

`addValuePartitions(dbHandle, newValues, [level=0], [locations])`

## Arguments {#arguments}

**dbHandle** is a database handle.

**newValues** is a scalar or vector indicating new partitions.

**level** \(optional\) is a non-negative integer. For a partitioned database with COMPO domain, we need to specify the level of the partitions that `addValuePartitions` applies if it is not for the first level of partitions. This level must be of a VALUE domain. The default value is 0.

**locations** \(optional\) is a STRING scalar/vector. If the paramater *locations* was specified when the database was created, we can use *locations* to specify where the new partitions located.

## Details {#details}

Append new values to the partition scheme of a database.

This database must be of VALUE domain or of COMPO domain with at least one level of VALUE domain.

## Examples {#examples}

In the following example, we append \(2017.08.12..2017.08.20\) to the partition scheme of a database of COMPO domain.

```
n=1000000
ID=rand(100, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(ID, date, x)

dbID=database(, RANGE, 0 50 100);
dbDate = database(, VALUE, 2017.08.07..2017.08.11)
db = database("dfs://compoDB", COMPO, [dbID, dbDate]);
pt = db.createPartitionedTable(t, `pt, `ID`date)
pt.append!(t)

addValuePartitions(db,2017.08.12..2017.08.20,1)
// output: 9
```

To add new partitions consecutively without appending new data, we need to reload the database before each `addValuePartitions` operation.

```
db=database("dfs://compoDB")
pt=loadTable(db,"pt")

t1=table(0..99 as ID,take(2017.08.12,100) as date,rand(10.0,100) as x)
pt.append!(t1)

select count(*) from loadTable("dfs://compoDB","pt")
// output: 1000100
```

