# addNode {#addnode}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`addNode(host, port, alias, [saveConfig=true], [nodeType='datanode'], [computeGroup]), [zone]`

## Arguments {#arguments}

**host** is a STRING scalar or vector indicating the IP address of the node\(s\).

**port** is a positive integral scalar or vector indicating the port number of the node\(s\).

**alias** is a STRING scalar or vector indicating the node alias\(es\).

**saveConfig** \(optional\) is a Boolean value indicating whether to save the information of the node in the configuration file `cluster.nodes` when adding the node. The default value is true.

**nodeType** \(optional\) is a STRING scalar or vector indicating the node type\(s\), which can be 'datanode' or 'computenode'.

**computeGroup** \(optional\) is a string indicating the compute group to which the compute node belongs to. If not specified, a compute node will be added without joining any compute group, and partition data will not be cached on the node.

**zone** \(optional\) is a string indicating the zone to which the node belongs to. If the cluster.nodes file has already defined zones, this parameter becomes mandatory and must match one of the zones. It cannot be set to an undefined zone or the default zone.

Note that the length of *host*, *port*, *alias*, *nodeType* must be consistent.

## Details {#details}

Add node\(s\) to a cluster. It can only be executed by administrator. The added nodes are not started. You can start the nodes in the cluster management web interface or in the command line.

Note that you need to deploy an agent before adding a node on a new machine.

## Examples {#examples}

Add a compute node “orca4”, and specify its compute group “orca”.

``` {#codeblock_gcg_tks_xbc}
addNode("192.168.1.243", 23796, "orca4", true, 'computenode', "orca");
```

