# addMarketHoliday {#addmarketholiday}

## Syntax {#syntax}

`addMarketHoliday(marketName, holiday)`

`addMarketHoliday(marketName, holiday, [dateType = 'holidayDate'])`

## Arguments {#arguments}

**marketName** is a STRING scalar, indicating the identifier of the trading calendar, e.g., the Market Identifier Code of an exchange, or a user-defined calendar name.

**holiday** is a vector of DATE type, indicating weekday holidays.

**holiday** is a vector of DATE type, indicating holiday dates or trading dates.

-   When *dateType*='holidayDate', *holiday* should be specified as the dates of weekday holidays.

-   When *dateType*='tradingDate', *holiday* should be specified as trading dates.


**dateType** \(optional\) is a string, indicating the type of the added file from which the trading calendar is generated. It can take one of the following values: 'holidayDate' \(default\) and 'tradingDate'.

## Details {#details}

Adds a holiday calendar online to generate a trading calendar.Adds a file of holiday dates or trading dates to generate a trading calendar. A CSV file named *marketName* will be generated in the directory specified by *marketHolidayDir*.

Note:

-   It can only be executed by an administrator.

-   It only takes effect on the current node. In a cluster, `pnodeRun` can be used to call this function on all data/compute nodes.

-   *marketName*must consist of four uppercase letters and cannot be the same as the file name in *marketHolidayDir*.


## Examples {#examples}

Example 1: Adding a custom trading calendar with *holiday* containing dates of weekday holidays

The following example demonstrates how to manually add a trading calendar named "DCBA".

``` {#codeblock_aql_lmk_zdc}
addMarketHoliday("DCBA",2022.01.03 2022.01.05)
```

A file named *DCBA.csv* will be generated in */server/marketHoliday/*, containing all specified holidays.

**Note**: When attempting to create a trading calendar, if you use an identifier \(like "DCBA"\) that already exists in the */server/marketHoliday/* directory, the system will block the operation with an error message: `The added market '<marketName>' already exists`, preventing duplication of trading calendars.

```
temporalAdd(2022.01.01,1,"DCBA")
//Output: 2022.01.04
```

``` {#codeblock_dyl_jxb_s1c}
index = [2022.01.01, 2022.01.02, 2022.01.03, 2022.01.04]
s = indexedSeries(index, 1..4)
s.resample("DCBA", sum);
/* output
label	col1
2021.12.31   6
2022.01.04   4
*/
```

Example 2: Adding a custom trading calendar with *holiday* containing trading dates on weekends

The following example demonstrates how to manually add a trading calendar named "AAAA".

``` {#codeblock_eyl_mxb_s1c}
tradingDates=[2024.02.08, 2024.02.09, 2024.02.18, 2024.02.19, 2024.02.20, 2024.02.21]
addMarketHoliday(marketName="AAAA", holiday=tradingDates, dateType='tradingDate')
```

A file named *AAAA.csv* will be generated in */server/marketHoliday/*. In the file is a column named "tradingDate", which contains data from the vector *tradingDates*.

``` {#codeblock_fyl_mxb_s1c}
temporalAdd(2024.02.09, 1, "AAAA") 
// Output: 2024.02.18
```

``` {#codeblock_gyl_mxb_s1c}
temporalAdd(2024.02.21, 1, "AAAA")
// Dates not included in AAAA.csv will throw an error: The returned date does not exist in trading calendar [AAAA].
```

Related functions: [updateMarketHoliday](../u/updateMarketHoliday.md), [getMarketCalendar](../g/getMarketCalendar.md), [getTradingCalendarType](../g/getTradingCalendarType.md).

