# addMCPTool {#addMCPTool}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`addMCPTool(name, func, [argNames], [argTypes], [description], [extraInfo])`

## Arguments {#arguments}

**name** is a STRING scalar, indicating the tool name.

**func** is a user-defined function.

**argNames** is a STRING vector specifying the argument names. Pass `[]` if no parameters are required.

**argTypes** is a STRING vector specifying the data types of arguments, which can be DolphinDB data types or JSON data types. Supported types include:

|DolphinDB Type|JSON Type|
|--------------|---------|
|STRING|"string"|
|TEMPORAL|"string"|
|DOUBLE|"number"|
|BOOL|"boolean"|
|STRING\[\]|"array&lt;string&gt;"|
|TEMPORAL\[\]|"array&lt;string&gt;"|
|DOUBLE\[\]|"array&lt;number&gt;"|
|BOOL\[\]|"array&lt;boolean&gt;"|

**description** \(optional\) A STRING scalar describing the tool.

**extraInfo** \(optional\) A dictionary where keys are strings and values are of type ANY or STRING, used to specify additional metadata. Currently,the only supported key is "title"

## Details {#details}

Defines a new MCP tool.

**Return value**: A string representing the tool name.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
def myTool(x) {
   return x * 2 + 1
}

info = {
    "title": "DolphinDB Tools"
}

addMCPTool(name="myTool", func=myTool, argNames=["a"], argTypes=["number"], description="This is a tool", extraInfo=info)
```

