# addGpFunction {#addGpFunction}

**Note:** This function is not supported by Community Edition. You can [get a trial](https://dolphindb.com/product#downloads-down) of Shark from DolphinDB official website.

## Syntax {#Syntax .section}

`addGpFunction(engine, func)`

## Arguments {#Arguments .section}

**engine** is the engine object returned by `createGPLearnEngine`.

**func**is a user-defined function. Currently it does not support complex assignment, `if` or `for` statement. Only `return` statement can be used to return a combination of the training functions \(see Appendix for supported functions\). For example:

``` {#codeblock_zqh_pzk_2bc}
def f(x, y){
  return cos(x+y)
}
```

## Details {#Details .section}

Add a user-defined training function to the GPLearn engine.

## Examples {#section_lgv_dhz_2bc .section}

``` {#codeblock_njq_2hz_2bc}
def f(x, y){
  return cos(x+y)
}
addGpFunction(engine,f)
```

**Parent topic:**[addRangePartitions](../../Functions/a/addRangePartitions.md)

## Appendix {#id_rt5_f5k_2bc}

The following table lists available functions for building and evolving formulas.

|Function|Description|
|--------|-----------|
|add\(x,y\)|Addition|
|sub\(x,y\)|Subtraction|
|mul\(x,y\)|Multiplication|
|div\(x,y\)|Division. If the absolute value of the divisor is less than 0.001, returns 1.|
|max\(x,y\)|Maximum value|
|min\(x,y\)|Minimum value|
|sqrt\(x\)|Square root of the absolute value|
|log\(x\)|Logarithm. If x is less than 0.001, returns 0.|
|neg\(x\)|Negation|
|reciprocal\(x\)|Reciprocal. If the absolute value of x is less than 0.001, returns 0.|
|abs\(x\)|Absolute value|
|sin\(x\)|Sine function|
|cos\(x\)|Cosine function|
|tan\(x\)|Tangent function|
|sig\(x\)|Sigmoid function|
|signum\(x\)|Returns the sign of x|
|mcovar\(x, y, n\)|Covariance of x and y within a sliding window of size n|
|mcorr\(x, y, n\)|Correlation of x and y within a sliding window of size n|
|mstd\(x, n\)|Sample standard deviation of x within a sliding window of size n|
|mmax\(x, n\)|Maximum value of x within a sliding window of size n|
|mmin\(x, n\)|Minimum value of x within a sliding window of size n|
|msum\(x, n\)|Sum of x within a sliding window of size n|
|mavg\(x, n\)|Average of x within a sliding window of size n|
|mprod\(x, n\)|Product of x within a sliding window of size n|
|mvar\(x, n\)|Sample variance of x within a sliding window of size n|
|mvarp\(x, n\)|Population variance of x within a sliding window of size n|
|mstdp\(x, n\)|Population standard deviation of x within a sliding window of size n|
|mimin\(x, n\)|Index of the minimum value of x within a sliding window of size n|
|mimax\(x, n\)|Index of the maximum value of x within a sliding window of size n|
|mbeta\(x, y, n\)|Least-squares estimate of the regression coefficient of x on y within a window of size n|
|mwsum\(x, y, n\)|Iner product of x and y within a sliding window of size n|
|mwavg\(x, y, n\)|Weighted average of x with y as weights within a sliding window of size n|
|mfirst\(x,n\)|First element of the window of size n|
|mlast\(x,n\)|Last element of the window of size n|
|mrank\(x,asc, n\)|Rank of x within the sliding window of size n|
|ratios\(x\)|Returns the value of x\(n\)/x\(n−1\)x\(n\) / x\(n-1\)|
|deltas\(x\)|Returns the value of x\(n\)−x\(n−1\)x\(n\) - x\(n-1\)|

Note: For moving window operators \(such as `mmax(x, n)`\), the parameter *n*, which represents the window size, is randomly selected from the *windowRange*vector specified in the `createGPLearnEngine` function. In the following example, the training process randomly selects a value from \[7,14,21\] as the window size.

``` {#codeblock_ubz_kgx_5dc}
engine = createGPLearnEngine(source, predVec, windowRange=[7,14,21])
```

